#!/bin/sh
#
# Load the pwm device driver module and create it's entries in /dev.
#


# parameter setup
module="paraseat.o"
device="paraseat"
group="sys"
mode="666"

# invoke insmod with all arguments given to us
/sbin/insmod -f $module $* || exit 1

# remove stale nodes
rm -f /dev/${device}[0-1]

major=`cat /proc/devices | awk "\\$2==\"$device\" {print \\$1}"`

mknod /dev/${device}0 c $major 0
mknod /dev/${device}1 c $major 1

# give appropriate group/permissions
chgrp $group /dev/${device}?
chmod $mode  /dev/${device}?
