% these 3 load commands are the slowest of this script:
load test2noattack.txt
load test2slowattack.txt
load test2veryslowattack.txt

z0=test2noattack(:,1) + i*test2noattack(:,2);
z1=test2slowattack(:,1) + i*test2slowattack(:,2);
z2=test2veryslowattack(:,1) + i*test2veryslowattack(:,2);

% z0=z0(1:35725); % there's an ugly replication or shift in the dc offset
                % visible between sample 35720 and 35730 in the IMAG ch. only.
% to see it, plot(imag(z0(35601:35800))); or plot(imag(z0(35701:35730)))
z0 = z0(35730:85602); % this safely gets rid of begin; and end will
                      % match better the slow and veryslow taken after dc offset

z0cal=calibrateradar(z0); % now it has zero mean and identity var in real, imag
z1cal=calibrateradar(z1,z0); % calibrate against clutter only so less outliers
z2cal=calibrateradar(z2,z0); % calibrate against clutter only so less outliers

subplot(231)
plot(z0cal);
title('test2 clutter')
axis([-6 6 -6 6]); axis('equal'); grid

subplot(232)
plot(z1cal);
title('test2 slow target')
axis([-6 6 -6 6]); axis('equal'); grid

subplot(233)
plot(z2cal);
title('test2 very slow target')
axis([-6 6 -6 6]); axis('equal'); grid

drawnow

ZZ0=tfmann(z0cal,500,500,1);
subplot(234)
%tvslog(abs(ZZ0),.001,1)
%grid; xlabel('time'); ylabel('frequency'); axis('xy')
tvfortf(ZZ0);

ZZ1=tfmann(z1cal,500,500,1);
subplot(235)
tvfortf(ZZ1);

ZZ2=tfmann(z2cal,500,500,1);
subplot(236)
tvfortf(ZZ2);

