#include <stdlib.h>
#include <curses.h>
#include <panel.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "plotz.h"
#include <stdio.h>   /* for printf() */
#include <comedilib.h>

// to compile: gcc plotz.c -lcomedi -lpanel -lncurses
// to run: ./a.out

// originally a sideways plot in ascii art, 0..79 (80 char)
// plot real part of radar as "+" and imag part as "x"
// and if real and imag are same, plot as "*"

// i wrote this program based on example howto use comedi from these sites:
// http://stm.lbl.gov/comedi/doc/comedilib-4.html
// http://stm.lbl.gov/comedi/doc/comedilib.html
// http://stm.lbl.gov/comedi/documentation.html

// this is for adjusting the gains on a small wearable radar i built:
// my signal processing algorithm described http://wearcam.org/chirplet.htm

// changed to real versus imag plot, working with taneem on ncurses
// to scale real part on 0..79 and imag part on 0..23 (or whatver terminal size)
// and use curses plot

int subdev = 0;         /* change this to your input subdevice */
int chan = 0;           /* change this to your channel */
int range = 0;          /* more on this later */
int aref = AREF_GROUND; /* more on this later */

int main(int argc,char *argv[])
{
  rader_info_ptr r;
  int done=0;
  int resp;
  comedi_t *it;
  int chan=0;
  lsampl_t data1, data2;
  int dat1, dat2;
  int n;
  int dis[80]={-1}; // -1 never occurs (so use for debug)
               
  it=comedi_open("/dev/comedi0");
               
  if((r = (rader_info_ptr) malloc(sizeof(rader_info)))==NULL){
     perror("malloc");
     exit(1);
  }
//  strcpy(r->device,RADER_DEVICE);
//  r->fd = open(r->device,O_RDWR);

  start_ncurses(r);
  getmaxyx(r->main_window,r->y_width,r->x_width);
  r->x_factor = RADER_POINTS/r->x_width;
  r->y_factor = RADER_POINTS/r->y_width;

  while (1)
    {
      comedi_data_read(it, subdev, 0, range, aref, &data1);
      comedi_data_read(it, subdev, 2, range, aref, &data2);
//      fprintf(stdout, "%d    %d\n", data1, data2);
//      dat1 = ((int) data1)/((int) 52); // 4096/80 is about 52
//      dat2 = ((int) data2)/((int) 52);
//      fprintf(stdout,"%d  %d  %d  %d",data1,dat1, data2, dat2);
//      fprintf(stdout,"%04d    %02d",data1,dat1);
//      for (n=0; n<80; n++) dis[n]=' ';
//      dis[dat1]='+';
//      dis[dat2]='x';
//      if (dat1==dat2) dis[dat1]='*'; // if real and imag have same value

// aaaaaaaaaaaaa real versus imag code goes here

/*****************************************************************************
 *			University of Toronto
 * (C) Copyright 2000           Taneem Ahmed <taneem@eyetap.org>         
 *****************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *****************************************************************************/

//  whatever read function needs to be used from comedilib
    r->x_val = data1;
    r->y_val = data2;
 
//    r->x_pos = ((float) r->x_val / r->x_factor) + ((float) r->x_width / 2);
//    r->y_pos = ((float) r->y_val / r->y_factor) + ((float) r->y_width / 2);
    r->x_pos = ((float) r->x_val / r->x_factor);
    r->y_pos = ((float) r->y_val / r->y_factor);
//    sprintf(msg,"pos x = %d, y = %d",r->x_pos,r->y_pos);
    //sprintf(msg,"dummy x = %d, y = %d",dummy_x,dummy_y);
//    print_err(r,msg);
    r->y_pos = r->y_width - r->y_pos; // fliupd since y defaults down
    attrset(A_BOLD);  // make bold symbols
    mvprintw(r->y_pos,r->x_pos,"*");
    refresh();
    attrset(A_NORMAL);
    mvprintw(r->y_pos,r->x_pos,"."); // puts blank to delete erase last point
    usleep(5000);
  };
  stop_ncurses(r);
//  close(r->fd);   /* close the fd for /dev/comedi? */
  return 0;
}

int start_ncurses(rader_info_ptr r){

  r->main_window = initscr();
  cbreak();
  noecho();
  nodelay(r->main_window,TRUE);
  keypad(r->main_window,TRUE);
   attrset(A_BOLD);  // make bold symbols
  return 0;
}

int print_err(rader_info_ptr r, const char *msg){
   int x,y;

   getyx(r->main_window,y,x);
   attrset(A_BOLD);
   mvprintw(19,10,"%s",msg);
   attrset(A_NORMAL);
   move(y,x);
   return 0;
}

void stop_ncurses(rader_info_ptr r){

  clear();
  refresh();
  endwin();
}

