%output is input after being made zeromean and identity covariance
%
%mean zero
%covariance is the identity
%
%example uses: z=calibrate(z);
%              w=calibrate(z); % w has zeromean and identity cov real and imag
%              w=calibrate(z,zref); % uses zref covariance

function w = calibrateradar(z,zref)

dcvalue=mean(z);
z=z-dcvalue;

if nargin>2
  error('must have 2 or fewer inputs')
end%if

if nargin<2
  zref=z; % use function itself as own reference
%  x=real(z);
%  y=imag(z);
end%if

if min(size(z))>1
  error('input must be a vector')
end%if

%moved this line up   z=z-mean(z);
q=inv(chol(covz(zref)));
w=mulz(z,q);

