% called by tffi_memorysave.m   ... therefore QUIET version
%
% does clt of each 512 pt segment of data passed by calling routine
%
% tff_???(b98(1:1024), .5, 99);  % produces a 99 by 99 image with freqlim .5
% tff_???(data, fracfreqlim, size)
%
% tff_???(data,fracfreqlim) % defaults size to 19 for quick contour plots
% tff_???(data)             % defaults to -.5,.5
%
% fracfreqlim = .5 gives image of likeness to chirps starting @f0 going up to f1
%
% if a 4th arg, id_files, is given (as a string), the features are saved to
%                         tfff________  (eg tfff_1 or tfff_b9825)

function clt = dummy_name(b,fracfreqlim,size_of_img,id_files)

axis('square')

if nargin < 3
  size_of_img = 19;
end%if
if nargin < 2
  fracfreqlim = .5;
end%if

xlo = -fracfreqlim;
xhi =  fracfreqlim;
ylo = -fracfreqlim;
yhi =  fracfreqlim;

M = size_of_img;
N = size_of_img;

len = length(b);

%%%time_est_per_line = len/3870*21/16*N/99; % one 3870pt line takes 21/16 min.
%%%disp(sprintf('est single usr sparc time PER LINE: %g min',time_est_per_line))

%%%disp('subtracting mean from data vector')
b = b-mean(b);
%%%disp('subtracted mean')

[fbeg,fend] = meshdom(linspace(xlo,xhi,N) , linspace(ylo,yhi,M));  
                                            % fbeg to right, fend up

clt = NaN*ones(M,N);   % avoid repeated calls to malloc
for m = 1:M        % do chirp likeness processing in TV order
  if ~rem(m,10)
    disp(sprintf('doing line %g of %g lines',m,M))
  end%if
  for n = 1:N
    f0 = fbeg(m,n);
    f1 = fend(m,n);
%%%    c = chirp(f0,f1,len,1).*hanning(len).';   % default samp rate is 1 anyway
    c = logonwh((f0+f1)/2,f1-f0,len);   % goes from f0 to f1 over len samples
%%%%NOT NEEDED for big kernels    c = c-mean(c);  % force DC to zero
    clt(m,n) = abs(c*conj(b));   % ``energy'' in each of the chirps
                                 % MAGNITUDE CLT, NOT ENERGY????
                                 % but MAG. is more compressed in dynamic range
  end%for
end%for

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  CLT info to display under each subplot  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pwr = sum(sum(clt.*conj(clt)));  % true power since clt is actually mag.
e = entropynor1(clt.^2);  % take (normalized)entropy of POWER ``spectrum''
[big m n] = max2(clt); % find the peak epoch location
clt_extent = extent2(clt); % should it be extent2(clt.^2)???
% Hypothesis 0: no chirp present (H0=pwr) ... H1: chirp present:
H1 = clt(m,n)^2; % same as <c|b>*conj<c|b>
H1overH0 = H1/pwr;
d = '  '; % delimiter between numbers
clt_info = [num2str(pwr) d num2str(e) d num2str(clt_extent) d num2str(H1overH0)]
if nargin > 3   % if an output file is specified
  filnam = ['tfff_' id_files];
  fprintf([filnam '.txt'],[clt_info '\n'])
end%if

contour(clt)  % no labels to be put in here
hold on
plot(1:size_of_img,1:size_of_img,'.')   % diag line  f0 = f1
x = (size_of_img+1)/2 - floor(size_of_img/10):    (size_of_img+1)/2 + floor(size_of_img/10);
y = (size_of_img+1)/2 + floor(size_of_img/10):-1: (size_of_img+1)/2 - floor(size_of_img/10);
plot(x,y,'.')  % tick mark (part of line  f0 = -f1 (fdiff=0))
xlabel(clt_info)
hold off
grid

