#include <stdio.h>   /* for printf() */
#include <comedilib.h>

// to compile: gcc plot.c -lcomedi
// to run: ./a.out

// sideways plot in ascii art, 0..79 (80 char)
// plot real part of radar as "+" and imag part as "x"
// and if real and imag are same, plot as "*"

// i wrote this program based on example howto use comedi from these sites:
// http://stm.lbl.gov/comedi/doc/comedilib-4.html
// http://stm.lbl.gov/comedi/doc/comedilib.html
// http://stm.lbl.gov/comedi/documentation.html

// this is for adjusting the gains on a small wearable radar i built:
// my signal processing algorithm described http://wearcam.org/chirplet.htm

int subdev = 0;         /* change this to your input subdevice */
int chan = 0;           /* change this to your channel */
int range = 0;          /* more on this later */
int aref = AREF_GROUND; /* more on this later */

int main(int argc,char *argv[])
{
  comedi_t *it;
  int chan=0;
  lsampl_t data1, data2;
  int dat1, dat2;
  int n;
  int dis[80]={-1}; // -1 never occurs (so use for debug)
               
  it=comedi_open("/dev/comedi0");
               
  while (1)
    {
      comedi_data_read(it, subdev, 0, range, aref, &data1);
      comedi_data_read(it, subdev, 2, range, aref, &data2);
//      fprintf(stdout, "%d    %d\n", data1, data2);
      dat1 = ((int) data1)/((int) 52); // 4096/80 is about 52
      dat2 = ((int) data2)/((int) 52);
//      fprintf(stdout,"%d  %d  %d  %d",data1,dat1, data2, dat2);
//      fprintf(stdout,"%04d    %02d",data1,dat1);
      for (n=0; n<80; n++) dis[n]=' ';
      dis[dat1]='+';
      dis[dat2]='x';
      if (dat1==dat2) dis[dat1]='*'; // if real and imag have same value
      for (n=0; n<80; n++) {
        if (dis[n]==' ') fprintf(stdout," ");
        if (dis[n]=='+') fprintf(stdout,"+");
        if (dis[n]=='x') fprintf(stdout,"x");
        if (dis[n]=='*') fprintf(stdout,"*");
      }
      fprintf(stdout,"\n");
    }
               
  return 0;
}

