#ifndef __RADER_PLOT_H_
#define __RADER_PLOT_H_

#define RADER_MIN	0
#define RADER_MAX	4095
#define RADER_POINTS	4096

#define RADER_DEVICE	"/dev/comdei0"

#define ERR_BEEP	beep(); \
			refresh()

typedef struct __rader_info{
  /* the ncurses window info */
  WINDOW	*main_window;
  int		x_width;
  int		y_width;
  int		x_factor;
  int		y_factor;
  /* zoom factor */
  int		zoom;
  /* current origin relative to (0,0) of the ncurse window */
  int		x_origine;
  int		y_origine;
  /* values read in from the rader driver */
  int		x_val;
  int		y_val;
  /* the corresponding x, y values for the window */
  int		x_pos;
  int		y_pos;
  /* device name */
  char		device[64];
  /* fd to the device */
  int		fd;
 
}rader_info;

typedef rader_info * rader_info_ptr;

int start_ncurses(rader_info_ptr);
int print_err(rader_info_ptr, const char *);
void stop_ncurses(rader_info_ptr);

#endif  /* __RADER_PLOT_H_ */
